/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketScreen;
import dev.emi.trinkets.TrinketScreenManager;
import dev.emi.trinkets.TrinketsNetwork;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.data.EntitySlotLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class TrinketsClient
implements ClientModInitializer {
    public static SlotGroup activeGroup;
    public static SlotType activeType;
    public static SlotGroup quickMoveGroup;
    public static SlotType quickMoveType;
    public static int quickMoveTimer;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TrinketsNetwork.SYNC_INVENTORY, (client, handler, buf, responseSender) -> {
            int entityId = buf.readInt();
            class_2487 inventoryData = buf.method_10798();
            class_2487 contentData = buf.method_10798();
            ArrayList<class_3545> contentUpdates = new ArrayList<class_3545>();
            ArrayList<ImmutableTriple> inventoryUpdates = new ArrayList<ImmutableTriple>();
            if (inventoryData != null) {
                for (String key : inventoryData.method_10541()) {
                    String[] split = key.split("/");
                    String group = split[0];
                    String slot = split[1];
                    class_2487 tag = inventoryData.method_10562(key);
                    inventoryUpdates.add(new ImmutableTriple((Object)group, (Object)slot, (Object)tag));
                }
            }
            if (contentData != null) {
                for (String key : contentData.method_10541()) {
                    class_1799 stack = class_1799.method_7915((class_2487)contentData.method_10562(key));
                    contentUpdates.add(new class_3545((Object)key, (Object)stack));
                }
            }
            client.execute(() -> {
                class_1297 entity = client.field_1687.method_8469(entityId);
                if (entity instanceof class_1309) {
                    TrinketsApi.getTrinketComponent((class_1309)entity).ifPresent(trinkets -> {
                        class_1723 patt3089$temp;
                        for (Triple entry : inventoryUpdates) {
                            TrinketInventory inv;
                            Map<String, TrinketInventory> slots = trinkets.getInventory().get(entry.getLeft());
                            if (slots == null || (inv = slots.get(entry.getMiddle())) == null) continue;
                            inv.applySyncTag((class_2487)entry.getRight());
                        }
                        if (entity instanceof class_1657 && (patt3089$temp = ((class_1657)entity).field_7498) instanceof TrinketPlayerScreenHandler) {
                            TrinketPlayerScreenHandler screenHandler = (TrinketPlayerScreenHandler)patt3089$temp;
                            screenHandler.trinkets$updateTrinketSlots(false);
                            if (TrinketScreenManager.currentScreen != null) {
                                TrinketScreenManager.currentScreen.trinkets$updateTrinketSlots();
                            }
                        }
                        for (Triple entry : contentUpdates) {
                            TrinketInventory inv;
                            String[] split = ((String)entry.method_15442()).split("/");
                            String group = split[0];
                            String slot = split[1];
                            int index = Integer.parseInt(split[2]);
                            Map<String, TrinketInventory> slots = trinkets.getInventory().get(group);
                            if (slots == null || (inv = slots.get(slot)) == null || index >= inv.method_5439()) continue;
                            inv.method_5447(index, (class_1799)entry.method_15441());
                        }
                    });
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TrinketsNetwork.SYNC_SLOTS, (client, handler, buf, responseSender) -> {
            class_2487 data = buf.method_10798();
            if (data != null) {
                HashMap slots = new HashMap();
                for (String id : data.method_10541()) {
                    Optional maybeType = class_2378.field_11145.method_17966(class_2960.method_12829((String)id));
                    maybeType.ifPresent(type -> {
                        class_2487 groups = data.method_10562(id);
                        if (groups != null) {
                            for (String groupId : groups.method_10541()) {
                                class_2487 group = groups.method_10562(groupId);
                                if (group == null) continue;
                                SlotGroup slotGroup = SlotGroup.read(group);
                                slots.computeIfAbsent(type, k -> new HashMap()).put(groupId, slotGroup);
                            }
                        }
                    });
                }
                client.execute(() -> {
                    EntitySlotLoader.CLIENT.setSlots(slots);
                    class_746 player = client.field_1724;
                    if (player != null) {
                        ((TrinketPlayerScreenHandler)player.field_7498).trinkets$updateTrinketSlots(true);
                        class_437 patt4984$temp = client.field_1755;
                        if (patt4984$temp instanceof TrinketScreen) {
                            TrinketScreen trinketScreen = (TrinketScreen)patt4984$temp;
                            trinketScreen.trinkets$updateTrinketSlots();
                        }
                        for (class_742 clientWorldPlayer : player.field_17892.method_18456()) {
                            ((TrinketPlayerScreenHandler)clientWorldPlayer.field_7498).trinkets$updateTrinketSlots(true);
                        }
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TrinketsNetwork.BREAK, (client, handler, buf, sender) -> {
            int entityId = buf.readInt();
            String[] split = buf.method_19772().split("/");
            String group = split[0];
            String slot = split[1];
            int index = buf.readInt();
            client.execute(() -> {
                class_1297 e = client.field_1687.method_8469(entityId);
                if (e instanceof class_1309) {
                    class_1309 entity = (class_1309)e;
                    TrinketsApi.getTrinketComponent(entity).ifPresent(comp -> {
                        TrinketInventory inv;
                        Map<String, TrinketInventory> groupMap = comp.getInventory().get(group);
                        if (groupMap != null && index < (inv = groupMap.get(slot)).method_5439()) {
                            class_1799 stack = inv.method_5438(index);
                            SlotReference ref = new SlotReference(inv, index);
                            Trinket trinket = TrinketsApi.getTrinket(stack.method_7909());
                            trinket.onBreak(stack, ref, entity);
                        }
                    });
                }
            });
        });
    }
}

